<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Spiritan School Admission Form</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #eef2f7;
      padding: 40px;
    }
    form {
      background: #fff;
      padding: 30px;
      width: 600px;
      margin: auto;
      border-radius: 10px;
      box-shadow: 0 0 15px rgba(0,0,0,0.1);
    }
    input, select, textarea {
      width: 100%;
      padding: 10px;
      margin-bottom: 20px;
      border: 1px solid #ccc;
      border-radius: 5px;
    }
    label {
      font-weight: bold;
      margin-top: 15px;
      display: block;
    }
    input[type="submit"] {
      background: #007bff;
      color: white;
      border: none;
      cursor: pointer;
      transition: 0.3s;
    }
    input[type="submit"]:hover {
      background: #0056b3;
    }
  </style>
</head>
<body>
  <form action="submit_admission.php" method="post" enctype="multipart/form-data">
    <h2 style="text-align: center;">SIGSS Admission Form</h2>

    <!-- Student Information -->
    <label>Full Name:</label>
    <input type="text" name="full_name" required>

    <label>Date of Birth:</label>
    <input type="date" name="dob" required>

    <label>Gender:</label>
    <select name="gender" required>
      <option value="">Select Gender</option>
      <option>Male</option>
      <option>Female</option>
    </select>

    <label>Nationality:</label>
    <input type="text" name="nationality" required>

    <label>State of Origin:</label>
    <input type="text" name="state" required>

    <label>LGA:</label>
    <input type="text" name="lga" required>

    <label>Religion:</label>
    <input type="text" name="religion" required>

    <!-- Academic Background -->
    <label>Previous School:</label>
    <input type="text" name="previous_school" required>

    <label>Last Class Completed:</label>
    <input type="text" name="last_class" required>

    <label>Class Intended:</label>
    <select name="class_intended" required>
      <option value="">Select Class</option>
      <option value="JSS 1">JSS 1</option>
      <option value="JSS 2">JSS 2</option>
      <option value="JSS 3">JSS 3</option>
      <option value="SSS 1">SSS 1</option>
      <option value="SSS 2">SSS 2</option>
      <option value="SSS 3">SSS 3</option>
    </select>

    <label>Academic Performance:</label>
    <input type="text" name="performance" required>

    <!-- Parent Information -->
     <label>Parent/Guardian Information:</label>
     <br>
    <label>Name:</label>
    <input type="text" name="parent_name" required>

    <label>Phone Number:</label>
    <input type="text" name="parent_phone" required>

    <label>Email Address:</label>
    <input type="email" name="email" required>

    <label>Occupation:</label>
    <input type="text" name="occupation" required>

    <label>Relationship to Student:</label>
    <input type="text" name="relationship" required>

    <label>Home Address:</label>
    <textarea name="address" required></textarea>

    <!-- Uploads -->
     <label>Upload only correct documents:</label> <br>
    <label>Passport Photograph:</label>
    <input type="file" name="passport" accept=".jpg,.jpeg,.png" required>

    <label>Birth Certificate:</label>
    <input type="file" name="birth_certificate" accept=".pdf,.jpg,.jpeg,.png" required>

    <label>Academic Result/Transfer Letter:</label>
    <input type="file" name="academic_result" accept=".pdf,.jpg,.jpeg,.png" required>

    <label>Payment Receipt <br> <i>Spiritan Int’l School Ltd <br> Account No:
1015458708 <br> Bank: Zenith</i>:</label>
    <input type="file" name="receipt" accept=".pdf,.jpg,.jpeg,.png" required>

    <input type="submit" value="Submit Application">
  </form>
</body>
</html>
